
#include <LPC17xx.h>                               // LPC17xx definitions


extern unsigned long triangle[32];

extern struct
{
  uint32_t  source;     // start of source area
  uint32_t  destination;// start of destination area
  uint32_t  next;       // address of next strLLI in chain
  uint32_t  control;    // DMACCxControl register
} LLI0;




int main (void)                                    // Main Program
{
  int i;

    SystemInit();                                  // Fcclk = 100 MHz

    for(i=0;i!=16;i++) triangle[i] = (((i+1)<<6) - 1)<<6;
    for(i=0;i!=16;i++) triangle[16+i] = (((16-i)<<6) - 64)<<6;

    LPC_PINCON->PINSEL1 |= (2<<20);                    // enable AOUT (P0.26) pin
	
	LPC_GPIO1->FIODIR	|=	(1<<28) | (1<<29);		//LED outputs (P1.28 and P1.29)
	LPC_GPIO1->FIOCLR	=  (1<<28);					//Turn off LED
	LPC_GPIO1->FIOSET	=  (1<<29);					//Turn on LED

    LLI0.source      = (uint32_t) &triangle[0];
    LLI0.destination = (uint32_t) &(LPC_DAC->DACR);
    LLI0.next        = (uint32_t) &LLI0;
    LLI0.control     = 1<<26 | 2<<21 | 2<<18 | 32;

    LPC_GPDMA->DMACConfig = 1;                         // enable the GPDMA controller
    LPC_GPDMA->DMACSync   = 0xFFFF;                    // enable synchro logic for all reqs

    LPC_GPDMACH0->DMACCSrcAddr  = (uint32_t) &triangle[0];
    LPC_GPDMACH0->DMACCDestAddr = (uint32_t) &(LPC_DAC->DACR);
    LPC_GPDMACH0->DMACCLLI      = (uint32_t) &LLI0;    // linked lists for ch0
    LPC_GPDMACH0->DMACCControl  = (32 % 4096)          // transfer size (0 - 11) = 32
                            | ((0 % 8) << 12)      // source burst size (12 - 14) = 1
                            | ((0 % 8) << 15)      // destination burst size (15 - 17) = 1
                            | ((2 % 8) << 18)      // source width (18 - 20) = 32 bit
                            | ((2 % 8) << 21)      // destination width (21 - 23) = 32 bit
                            | ((0 % 2) << 24)      // source AHB select (24) = AHB 0
                            | ((0 % 2) << 25)      // destination AHB select (25) = AHB 0
                            | ((1 % 2) << 26)      // source increment (26) = increment
                            | ((0 % 2) << 27)      // destination increment (27) = no increment
                            | ((0 % 2) << 28)      // mode select (28) = access in user mode
                            | ((0 % 2) << 29)      // (29) = access not bufferable
                            | ((0 % 2) << 30)      // (30) = access not cacheable
                            | ((0 % 2) << 31);     // terminal count interrupt disabled

    LPC_GPDMACH0->DMACCConfig   =  1                   // channel enabled (0)
                            | (0 << 1)             // source peripheral (1 - 5) = none
                            | (7 << 6)             // destination peripheral (6 - 10) = DAC
                            | (1 << 11)            // flow control (11 - 13) = mem to per
                            | (0 << 14)            // (14) = mask out error interrupt
                            | (0 << 15)            // (15) = mask out terminal count interrupt
                            | (0 << 16)            // (16) = no locked transfers
                            | (0 << 18);           // (27) = no HALT

    LPC_DAC->DACCNTVAL = 250;                          // DACclk = 25 MHz, so 10 usec interval
    LPC_DAC->DACCTRL   = 1<<3 | 1<<2 | 1<<1;           // DMA, timer running, dbuff

	i = 0;
    while(1)                                       // Loop forever
    {
		/* Toggle LED to indicate that CPU is running */
		if(i == 0xF0000){
			LPC_GPIO1->FIOPIN	^=  (1<<28) | (1<<29);
			i = 0;
			/* If button INT0 is pressed, turn off LEDs and go to sleep */
			if(!(LPC_GPIO2->FIOPIN & (1<<10))){
				LPC_GPIO1->FIOCLR = (1<<28) | (1<<29);
				__WFI();
			}
		}else
			i++;
					
    }
}
